# Knowledge Distillation for Graph Augmentation (KDGA)

This is a PyTorch implementation of the Knowledge Distillation Improves Graph Augmentation (KDGA), and the code includes the following modules:

* Dataset Loader (Cora, Citeseer, Texas, Cornell, Wisconsin, Actor, Chameleon, and Squirrel)

* GCN Classifier for implementing $$p(Y|A,X)$$, and Graph Augmentation Module - GraphAug for implementing $p(\widehat{A}|A,X)$

* Training paradigm for pre-training and fine-tuning on eight real-world datasets

* Visualization and evaluation metrics 

  

## Main Requirements

* numpy==1.19.2
* scipy==1.3.1
* torch==1.6.0
* pyro==1.3.0



## Description

* main.py  
  * pretrain_Augmentor() -- Pretrain Graph Augmentation Module - GraphAug
  * pretrain_Classifier() -- Pretrain GNN Classifier
  * main() -- Train the model for node classification task on eight real-world datasets
* model.py  
  
  * GCNLayer() -- GCN Layer
  * GCN_Classifier() -- GCN Classifier for implementing the function $$p(Y|A,X)$$
  * Augmentor() -- Graph Augmentation Module - GraphAug for implementing the function $p(\widehat{A}|A,X)$
  * com_distillation_loss() -- Calculate the KL-divergence Loss for knowledge distillation
* dataset.py  

  * load_data() -- Load Cora, Citeseer, Texas, Cornell, Wisconsin, Actor, Chameleon, and Squirrel datasets
* utils.py  
  * evaluation() -- Calculate classification accuracy




## Running the code

1. Install the required dependency packages

3. To get the results on a specific *dataset*, please run with proper hyperparameters:

  ```
python main.py --dataset data_name --loss_mode mode
  ```

where the *data_name* is one of the eight datasets (Cora, Citeseer, Texas, Cornell, Wisconsin, Actor, Chameleon, and Squirrel), and *loss_mode* denotes different experimental settings (-1: default optimal hyperparameters obtained by NNI; 0: w/ parameter-shared DKGA; 1: w/ parameter-independent DKGA; 2: vanilla GraphAug; 3: vanilla GCN). Use the default optimal hyperparameters on the *Citeseer* dataset as an example: 

```
python main.py --dataset citeseer --loss_mode -1
```



## License

Knowledge Distillation Improves Graph Augmentation (KDGA) is released under the MIT license.